//Return types:

#define UCR200_OK 0						//Function executed without errors.
#define UCR200_DEVICE_NOT_OPENED 1		//Device could not connect or the connection determinated.
#define UCR200_ERROR 2					//Other communication or timeout errors.

//Exported function prototypes:

extern "C" __declspec(dllexport) int UCR200Open(void);
//UCR200Open , Opens a connection to the device.

extern "C" __declspec(dllexport) int UCR200Close(void);
//UCR200Close , Closes the connection to the device.

extern "C" __declspec(dllexport) int UCR200Settings(int LEDTime, int LCDTime, int LCDBrightness, int RFCh, int Region);
//UCR200Settings , wireless pendant device basic settings
//LEDTime , background lights time in seconds (range:0-255)
//LCDTime , LCD display on time before going to idle, time in seconds. (range:0-255)
//LCDBrightness , the strength of the backlight (range:0-255)
//RFCh , selects the radio frequency channel (range:0-3)
//Region , selects the usage region (range:0->Europe, 1->USA,Canada,Australia and all others)

extern "C" __declspec(dllexport) int UCR200Display(int Line, char Txt[20],int InvStart, int InvStop);
//UCR200Display , sends text data to the LCD display. 
//Line , Selects the number of row to write the text to (range:0-3)
//Text[] , The text string to write to the selected row on the dispay (range:22 characters)
//InvStart , the starting index of the inverted text area in the selected row (range:0-22)
//InvStop , the ending index of the inverted text area in the selected row (range:0-22)
//Note: If the InvStart and Invstop values are both 22 then there is no inverted area shown on the selected row, all characters displays normal in this case.

extern "C" __declspec(dllexport) int UCR200Status(int *Keyboard, int *MPG, bool	*RFConnect, int *RFSignal);
//UCR200Status
//Keyboard, MPG, RFconnect, RFSignal strength readout from the pendant.
//Keyboard values:
//1 Start/Pause
//2 Stop
//4 Estop
//8 Spindle On/Off
//16 Zero Axis
//32 MPG Mode
//64 MPG Speed
//128 MPG Step
//256 MPG Axis
//MPG value contains the encoder ticks count after the last read. In other words the readout is an incremental value between the last readout and the current readout.
//If the RFConnect value is 1, means the pendant is in active connection with the receiver, if the value is 0 means the pendant is in sleep mode and the connection is not active.
//RFSignal parameter shows the radio signal strength (range:0-100)
